#include "GetPoint.js"

function UpdatePrompt( whichpoint )
{
	var ui = moi.ui;

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	
	var showsecond = (whichpoint == 1);
	if ( ui.commandUI.arcstyle.value == 'Start, End, On' )
		showsecond = !showsecond;
	
	ui.showUI( showsecond ? 'SecondPrompt' : 'ThirdPrompt' );
	ui.hideUI( showsecond ? 'ThirdPrompt' : 'SecondPrompt' );
	ui.endUIUpdate();
}

function GetArcPoint( pointpicker, whichpoint )
{
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( pointpicker.event == 'arcstyle' )
			UpdatePrompt( whichpoint );
	}
	
	return true;
}

function DoArc3pt()
{
	var ui = moi.ui;
	var pointpicker = ui.createPointPicker();
	
	if ( !GetPoint( pointpicker ) )
		return;	
		
	UpdatePrompt( 1 );

	var arcfactory = moi.command.createFactory( 'arc3pt' );
	
	ui.bindUIToInput( 'arcstyle', 'value', arcfactory.getInput(3) );

	arcfactory.setInput( 0, pointpicker.pt );

	pointpicker.bindResultPt( arcfactory.getInput(1) );

	if ( !GetArcPoint( pointpicker, 1 ) )
		return;

	UpdatePrompt( 2 );		
		
	pointpicker.clearBindings();
	pointpicker.bindResultPt( arcfactory.getInput(2) );
	
	if ( !GetArcPoint( pointpicker, 2 ) )
		return;

	arcfactory.commit();
}

DoArc3pt();
